/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskCRSVersionConsistency;
import oracle.ops.verification.framework.engine.task.TaskDaemonLiveliness;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCRSIntegrity
extends Task {
    private boolean m_toPerformConsistencyCheck = true;
    private boolean m_versionConsistencyMandatory = false;
    private VerificationType m_vfyType;

    public TaskCRSIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskCRSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskCRSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Performing CRS Integrity verification task... ");
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4032", false));
        this.performCRSIntegrityChecks();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4250", false));
            return true;
        }
        if (!this.m_resultSet.anyFailure()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4253", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4251", false));
        return false;
    }

    void performCRSIntegrityChecks() {
        Object newSoftVer = null;
        ArrayList upgNodeVer = new ArrayList();
        ArrayList curNodeVer = new ArrayList();
        Object curNodeArr = null;
        Object upgNodeArr = null;
        boolean upgdSum = true;
        ErrorDescription errDesc = null;
        String[] validNodeArr = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, this.m_resultSet);
        if (validNodeArr == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        String activeCRSVer = VerificationUtil.getCRSActiveVersion();
        if (activeCRSVer == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to retrieve active version for CRS");
            }
            errDesc = new ErrorDescription("5300", s_msgBundle);
            ReportUtil.printError(errDesc.getErrorMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        if (this.m_toPerformConsistencyCheck) {
            TaskCRSVersionConsistency taskCRSVer = new TaskCRSVersionConsistency(validNodeArr);
            taskCRSVer.setConsistenyMandatory(this.m_versionConsistencyMandatory);
            taskCRSVer.setVerificationType(this.m_vfyType);
            taskCRSVer.perform();
            Trace.out((String)("Upload taskCRSVer.getResultSet() >>>>" + LSEP));
            this.m_resultSet.uploadResultSet(taskCRSVer.getResultSet());
        }
        if (activeCRSVer.startsWith("11.2") || activeCRSVer.startsWith("12.")) {
            this.performChecksFor11gR2(validNodeArr);
        } else {
            this.performChecksForPre11gR2(validNodeArr);
        }
    }

    void performChecksFor11gR2(String[] validNodeArr) {
        String exeHome = VerificationUtil.getCRSHome();
        if (exeHome == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to retrieve CRS home");
            }
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("5301", false)));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("exeHome = '" + exeHome + "'"));
        }
        String cmdSpec = exeHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "crsctl check cluster";
        GlobalExecution globalExec = new GlobalExecution();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Attempt to run command:'" + cmdSpec + "' on valid nodes:'" + VerificationUtil.strArr2List(validNodeArr) + "'"));
        }
        ResultSet crsResultSet = new ResultSet();
        Hashtable crsCheckOutput = globalExec.runExeWithOutput(validNodeArr, cmdSpec, crsResultSet);
        for (String node : validNodeArr) {
            ErrorDescription errDesc;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Checking the result of command execution on node: '" + node + "'"));
            }
            Result result = crsResultSet.getResult(node);
            String etOutput = (String)crsCheckOutput.get(node);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("exectask Output is:'" + etOutput + "'"));
            }
            if (result.getStatus() == 2) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nFailed to execute exectask command: " + cmdSpec + "\n on node '" + node + "'" + "\n command output: " + etOutput));
                }
                errDesc = new ErrorDescription("5302", new String[]{node}, s_msgBundle);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdSpec + LSEP + etOutput);
                ReportUtil.printError(errDesc.getErrorMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 2);
                continue;
            }
            String cmdOutput = VerificationUtil.fetchVerificationValue(etOutput);
            String cmdExitStat = VerificationUtil.fetchVerificationResult(etOutput);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("cmdExitStat is:'" + cmdExitStat + "'" + LSEP + "cmdOutput is:'" + cmdOutput + "'"));
            }
            if (!cmdExitStat.equals("0")) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nExectask command: " + cmdSpec + "\n on node '" + node + "'" + "\n encountered the following error: " + cmdOutput));
                }
                errDesc = new ErrorDescription("5302", new String[]{node}, s_msgBundle);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdSpec + LSEP + cmdOutput);
                ReportUtil.printError(errDesc.getErrorMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 2);
                continue;
            }
            String[] outlist = VerificationUtil.getTokensAsArray(cmdOutput, System.getProperty("line.separator"));
            boolean CSS_online = false;
            boolean CRS_online = false;
            boolean EM_online = false;
            for (String line : outlist) {
                if (line.contains("CRS-4529")) {
                    CSS_online = true;
                }
                if (line.contains("CRS-4537")) {
                    CRS_online = true;
                }
                if (!line.contains("CRS-4533")) continue;
                EM_online = true;
            }
            if (CSS_online && CRS_online && EM_online) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Oracle clusterware is in a healthy state on node '" + node + "'"));
                }
                ReportUtil.println(s_msgBundle.getMessage("5306", false, (Object[])new String[]{node}));
                this.m_resultSet.addResult(node, 1);
                continue;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Oracle clusterware on node '" + node + "'" + "is not ONLINE" + LSEP + "Command output is: '" + cmdOutput + "'"));
            }
            errDesc = new ErrorDescription("5305", new String[]{node}, s_msgBundle);
            errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdOutput);
            ReportUtil.printError(errDesc.getErrorMessage());
            this.m_resultSet.addErrorDescription(node, errDesc);
            this.m_resultSet.addResult(node, 3);
        }
    }

    void performChecksForPre11gR2(String[] validNodeArr) {
        String crs_int_name = VerificationUtil.getDaemonInternalName("crsd");
        if (crs_int_name == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        String crs_disp_name = VerificationUtil.getDaemonDisplayName("crsd");
        if (crs_disp_name == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        String css_int_name = VerificationUtil.getDaemonInternalName("ocssd");
        if (css_int_name == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        String css_disp_name = VerificationUtil.getDaemonDisplayName("ocssd");
        if (css_disp_name == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        String evm_int_name = VerificationUtil.getDaemonInternalName("evmd");
        if (evm_int_name == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        String evm_disp_name = VerificationUtil.getDaemonDisplayName("evmd");
        if (evm_disp_name == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("CRS Internal Name ->" + crs_int_name + LSEP + "CRS Display Name ->" + crs_disp_name + LSEP + "CSS Internal Name ->" + css_int_name + LSEP + "CSS Display Name ->" + css_disp_name + LSEP + "EVM Internal Name ->" + evm_int_name + LSEP + "EVM Display Name ->" + evm_disp_name));
        }
        TaskDaemonLiveliness taskDaemon = new TaskDaemonLiveliness(validNodeArr);
        taskDaemon.setDaemonName("crsd");
        taskDaemon.perform();
        ResultSet crsResultSet = taskDaemon.getResultSet();
        taskDaemon = new TaskDaemonLiveliness(validNodeArr);
        taskDaemon.setDaemonName("ocssd");
        taskDaemon.perform();
        ResultSet cssResultSet = taskDaemon.getResultSet();
        taskDaemon = new TaskDaemonLiveliness(validNodeArr);
        taskDaemon.setDaemonName("evmd");
        taskDaemon.perform();
        ResultSet evmResultSet = taskDaemon.getResultSet();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"\n>>>> TaskCRSIntegrity:: Upload crsResultSet >>>>\n");
        }
        this.m_resultSet.uploadResultSet(crsResultSet);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"\n>>>> TaskCRSIntegrity:: Upload cssResultSet >>>>\n");
        }
        this.m_resultSet.uploadResultSet(cssResultSet);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"\n>>>> TaskCRSIntegrity:: Upload evmResultSet >>>>\n");
        }
        this.m_resultSet.uploadResultSet(evmResultSet);
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4033", false));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), crs_disp_name, css_disp_name, evm_disp_name);
        Hashtable t_crs = crsResultSet.getResultTable();
        Hashtable t_css = cssResultSet.getResultTable();
        Hashtable t_evm = evmResultSet.getResultTable();
        Vector<String> aliveNodeVect_crs = new Vector<String>();
        Vector<String> aliveNodeVect_css = new Vector<String>();
        Vector<String> aliveNodeVect_evm = new Vector<String>();
        Enumeration e = t_crs.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result check_result = (Result)t_crs.get(node);
            int check_status = check_result.getStatus();
            if (check_status == 1) {
                aliveNodeVect_crs.add(node);
            }
            String runStatus_crs = this.getRunStatus(check_status);
            check_result = (Result)t_css.get(node);
            check_status = check_result.getStatus();
            if (check_status == 1) {
                aliveNodeVect_css.add(node);
            }
            String runStatus_css = this.getRunStatus(check_status);
            check_result = (Result)t_evm.get(node);
            check_status = check_result.getStatus();
            if (check_status == 1) {
                aliveNodeVect_evm.add(node);
            }
            String runStatus_evm = this.getRunStatus(check_status);
            ReportUtil.writeRecord(node, runStatus_crs, runStatus_css, runStatus_evm);
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("CRS is alive on nodes: " + VerificationUtil.strVect2List(aliveNodeVect_crs) + LSEP + "CSS is alive on nodes: " + VerificationUtil.strVect2List(aliveNodeVect_css) + LSEP + "EVM is alive on nodes: " + VerificationUtil.strVect2List(aliveNodeVect_evm)));
        }
        if (aliveNodeVect_crs.size() != 0) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4252", false));
            ReportUtil.println(LSEP + s_msgBundle.getMessage("4034", false));
            GlobalExecution globalExec = new GlobalExecution();
            ResultSet crsHealthResultSet = new ResultSet();
            String[] aliveNodeArr_crs = aliveNodeVect_crs.toArray(new String[aliveNodeVect_crs.size()]);
            boolean crsHealthResult = globalExec.checkCRShealth(aliveNodeArr_crs, crsHealthResultSet);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"AFTER CRS Health verification ... ");
            }
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8002", false));
            Hashtable t_crsHealth = crsHealthResultSet.getResultTable();
            e = t_crsHealth.keys();
            while (e.hasMoreElements()) {
                ErrorDescription errDesc;
                String crsOK;
                String node = (String)e.nextElement();
                Result result = (Result)t_crsHealth.get(node);
                if (result.getStatus() == 1) {
                    crsOK = ReportUtil.YES;
                } else if (result.getStatus() == 3) {
                    crsOK = ReportUtil.NO;
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7594", true, (Object[])new String[]{crs_disp_name, node}), s_msgBundle, "7594");
                    this.m_resultSet.addErrorDescription(node, errDesc);
                } else {
                    crsOK = ReportUtil.UNKNOWN;
                    errDesc = new ErrorDescription("7595", new String[]{node}, s_msgBundle);
                    this.m_resultSet.addErrorDescription(node, errDesc);
                }
                ReportUtil.writeRecord(node, crsOK);
            }
            if (crsHealthResultSet.getStatus() == 1) {
                ReportUtil.printResult(s_msgBundle.getMessage("4035", false));
            } else {
                ReportUtil.printResult(s_msgBundle.getMessage("4036", false));
                ReportUtil.printErrorNodes(crsHealthResultSet);
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"\n>>>> TaskCRSIntegrity:: Upload crsHealthResultSet >>>>\n");
            }
            this.m_resultSet.uploadResultSet(crsHealthResultSet);
        }
    }

    private String getRunStatus(int status) {
        if (status == 1) {
            return ReportUtil.YES;
        }
        if (status == 3) {
            return ReportUtil.NO;
        }
        return ReportUtil.UNKNOWN;
    }

    @Override
    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4423", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4474", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }

    public void setVersionConsistencyMandatory(boolean versionConsistencyMandatory) {
        this.m_versionConsistencyMandatory = versionConsistencyMandatory;
    }

    public void setToPerformConsistencyCheck(boolean toPerformConsistencyCheck) {
        this.m_toPerformConsistencyCheck = toPerformConsistencyCheck;
    }

    public void setVerificationType(VerificationType verType) {
        this.m_vfyType = verType;
    }
}

